# 实现买票的功能
本章实现买票的功能，假设买票的功能只能在 Native 端实现，这时 在电影列表页面，点击购买按钮，Flutter 就会调用 Native 的代码来实现买票，所以这节的主要内容就是Flutter 调用 Native 的能力。

注意，在这里买票的功能用弹窗来模拟的。

## 首先在 Native 端实现买票功能
假设这里 Native 端是 Android，因为要在 Native 端实现，所以要用 Android Studio。

#### 在 Android Studio 里打开工程
在 Android Studio 里打开 Flutter 里 Android 部分的工程：

1. 打开  Android Studio 
2. 选择 `Open an existing Android Studio project`,或者 `File` -> `Open`
3. 选择文件夹： `The-Guide-to-the-Flutter/flutter_doubanmovie/android`，然后点击 `Open`

这样就打开了 Flutter 里 Android 部分的工程,然后在 `app/java/com.exammple.flutter_doubanmovie` 里找到 `MainActivity.java`

#### 实现功能
在 `MainActivity.java` 里实现功能：
```
package com.example.flutter_doubanmovie;

import android.app.AlertDialog;
import android.os.Bundle;
import android.widget.Toast;

import io.flutter.app.FlutterActivity;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugins.GeneratedPluginRegistrant;

public class MainActivity extends FlutterActivity {
  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    GeneratedPluginRegistrant.registerWith(this);

    new MethodChannel(getFlutterView(), "flutter.doubanmovie/buy").setMethodCallHandler(new MethodChannel.MethodCallHandler() {
      @Override
      public void onMethodCall(MethodCall methodCall, MethodChannel.Result result) {
        switch (methodCall.method){
          case "buyTicket":
            //显示dialog
            new AlertDialog.Builder(MainActivity.this)
                    .setTitle("买票")
                    .setMessage((String)methodCall.arguments)
                    .create().show();
            //返回消息
            result.success(0);
            return;
          default:
            result.notImplemented();
            return;
        }
      }
    });
  }
}
```

用到了 `MethodChannel` 来监听来自 Flutter 的调用，其中 `flutter.doubanmovie/buy` 是用来区别不同的 MethodChannel，这个在 Dart 里也需要用到。

在 `onMethodCall` 里，`methodCall.method` 是方法名，`methodCall.arguments` 是参数，`result` 是将执行结果返回给 Flutter。

## 在 Flutter 端调用 Native 的买票功能
然后打开 VS Code ，在 `HotMovieItemWidget.dart` 里实现调用 Native 买票的功能。

#### 先给买票按钮添加点击事件
代码如下：
```
OutlineButton(
  child: Text(
    '购票',
    style: TextStyle(fontSize: 16),
  ),
  color: Colors.red,
  textColor: Colors.red,
  highlightedBorderColor: Colors.red,
  borderSide: BorderSide(color: Colors.red),
  onPressed: () {
    
  },
)
```

#### 添加 MethodChannel
```
class HotMovieItemWidgetState extends State<HotMovieItemWidget> {
  static const methodChannel = const MethodChannel('flutter.doubanmovie/buy');
  
  ...
}
```

这里 `flutter.doubanmovie/buy` 要和 Native 的保持一致。

#### 调用 Native 的功能
在买票按钮的 `onPressed` 里添加：
```
onPressed: () {
    methodChannel.invokeMethod('buyTicket',
    '购买 ' + widget.hotMovieData.title + ' 电影票一张');
},
```

运行效果：

![](https://user-gold-cdn.xitu.io/2019/4/29/16a686393bff6504?w=384&h=768&f=png&s=140213)

注意：这里功能是在 Android 上实现的，请使用 Android 的模拟器。